# タイミング
もしメソッドを本気で最適化したいなら、このゲームで時間がどのように計測されるかを理解する必要があります。このアンロックは、まさにそのためのものです。

## 新しい関数
物事がどれくらい時間がかかるかを測定するための便利な関数が2つあります：

`get_time()` はゲーム開始からの時間を秒単位で返します。

`get_tick_count()` は実行開始から実行されたtickの数を返します。

これら2つの関数と `quick_print()` は、完全にコストがかかりません。呼び出し操作でさえも無料です。

## ランタイムの詳細

### 注意
これは現実世界でのパフォーマンスの仕組みとは異なります。これらは、このゲームで一貫性のある理解しやすいタイミングモデルを持つために作られたルールです。
コードを極限まで最適化したい場合にのみ、これを気にするでしょう。


コード実行の基本的な時間の単位は「tick」と呼ばれます。スピードアップグレードやパワーがない場合、実行は毎秒 `400` ticksのレートで進行します。

一般的に、`+、-、*、/、//、%、and、or、...` のような2つの値を組み合わせる操作は、実行に1 tickかかります。
単一の値に対する `-` と `not` はコストがかかりません。
`if` 分岐も実行に1 tickかかります（条件式を評価する時間とは別に）。
関数呼び出しや変数の読み書きは無料ですが、関数定義は1 tickかかります。
`import` ステートメントは無料です。
`.` 演算子でインポートされたモジュールにアクセスするのは無料です。
関数やモジュールが引数や変数代入を介して渡された場合、それを使用すると0ではなく1 tickかかります。
`for` と `while` ループは開始に1 tickかかりますが、反復自体は無料です（条件/シーケンス式を評価する時間を除く）。
`return`、`break`、`continue` はすべて無料です。
`pass` は1 tickかかるので、正確な遅延を作成するために使用できます。
データ構造へのインデックス参照は、インデックス演算子に1 tickかかり、辞書やセットの場合は、キーのサイズに応じて追加のtickがかかります。

組み込み関数が実行にかかるtick数は、各関数のドキュメントに個別に記載されています。